<?php
header('Content-Type: application/json');

$host = "localhost";
$dbname = "joshuakitoka_danso";
$username = "joshuakitoka_danso";
$password = "mmicrea2025";

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["error" => $e->getMessage()]);
    exit();
}

///////////////////////////////////////////////////////
// LOGIQUE PIERRE FEUILLE CISEAU
///////////////////////////////////////////////////////
function combatResultat($attacker, $defender) {
    if ($attacker == $defender) {
        return "egalite";
    }

    if (
        ($attacker == "pierre" && $defender == "ciseau") ||
        ($attacker == "ciseau" && $defender == "feuille") ||
        ($attacker == "feuille" && $defender == "pierre")
    ) {
        return "avantagé";
    }

    return "desavantage";
}

$action = $_POST["base"] ?? "";

///////////////////////////////////////////////////////
// GET ETAT
///////////////////////////////////////////////////////
if ($action === "get") {
    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
    exit();
}

///////////////////////////////////////////////////////
// RESET PARTIE
///////////////////////////////////////////////////////
if ($action === "start") {
    $stmt = $conn->prepare("
        UPDATE game SET
            joueur = 1,
            vaisseau1 = 5, vaisseau2 = 5,
            pierre1 = 3, feuille1 = 3, ciseau1 = 3,
            pierre2 = 3, feuille2 = 3, ciseau2 = 3,

            attaque_joueur = NULL,
            attaque_drone = NULL,
            attaque_cible = NULL,
            defense_drone = NULL,
            phase = 'attente',

            joker1 = 2,
            joker2 = 2,

            bluff_annonce = NULL,
            bluff_reel = NULL,
            bluff_choix = NULL,
            bluff_joueur = NULL,
            phase_bluff = NULL

        WHERE id = 1
    ");
    $stmt->execute();

    echo json_encode(["status" => "started"]);
    exit();
}

///////////////////////////////////////////////////////
// ATTAQUE CLASSIQUE (phase 1)
///////////////////////////////////////////////////////
if ($action === "attack") {

    $joueur = intval($_POST["joueur"]);
    $drone = $_POST["drone"];   // pierre, feuille, ciseau
    $cible = $_POST["cible"];   // pierre, feuille, ciseau, vaisseau

    // Etat de la partie
    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    $game = $stmt->fetch(PDO::FETCH_ASSOC);

    // Pas de bluff en cours
    if (!empty($game["phase_bluff"])) {
        echo json_encode(["error" => "bluff_en_cours"]);
        exit();
    }

    if ($game["joueur"] != $joueur) {
        echo json_encode(["error" => "pas_ton_tour"]);
        exit();
    }

    if ($game["phase"] !== "attente") {
        echo json_encode(["error" => "phase_invalide"]);
        exit();
    }

    // Drone attaquant vivant
    $fieldAtt = $drone . $joueur;
    if ($game[$fieldAtt] <= 0) {
        echo json_encode(["error" => "drone_mort"]);
        exit();
    }

    // Enregistrer attaque
    $stmt = $conn->prepare("
        UPDATE game SET
            attaque_joueur = :j,
            attaque_drone = :d,
            attaque_cible = :c,
            phase = 'defense'
        WHERE id = 1
    ");
    $stmt->execute([
        ":j" => $joueur,
        ":d" => $drone,
        ":c" => $cible
    ]);

    echo json_encode(["status" => "attaque_enregistrée"]);
    exit();
}

///////////////////////////////////////////////////////
// DEFENSE (phase 2)
///////////////////////////////////////////////////////
if ($action === "defend") {

    $def_joueur = intval($_POST["joueur"]);
    $def_drone = $_POST["drone"]; // pierre, feuille, ciseau

    // Etat
    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    $game = $stmt->fetch(PDO::FETCH_ASSOC);

    // Pas de bluff en cours
    if (!empty($game["phase_bluff"])) {
        echo json_encode(["error" => "bluff_en_cours"]);
        exit();
    }

    if ($game["phase"] !== "defense") {
        echo json_encode(["error" => "phase_invalide"]);
        exit();
    }

    $atk_joueur = intval($game["attaque_joueur"]);
    $atk_drone = $game["attaque_drone"];
    $atk_cible = $game["attaque_cible"];

    // Le défenseur doit etre l'autre joueur
    if ($def_joueur == $atk_joueur) {
        echo json_encode(["error" => "pas_ton_role"]);
        exit();
    }

    // Drone défenseur vivant
    $defField = $def_drone . $def_joueur;
    if ($game[$defField] <= 0) {
        echo json_encode(["error" => "drone_defenseur_mort"]);
        exit();
    }

    ///////////////////////////////////////////////////
    // Cas vaisseau directement
    ///////////////////////////////////////////////////
    if ($atk_cible === "vaisseau") {

        $vaisseauCol = "vaisseau" . $def_joueur;
        $newHP = max(0, $game[$vaisseauCol] - 1);

        $stmt = $conn->prepare("
            UPDATE game SET
                $vaisseauCol = :hp,
                attaque_joueur = NULL,
                attaque_drone = NULL,
                attaque_cible = NULL,
                defense_drone = NULL,
                phase = 'attente',
                joueur = :next
            WHERE id = 1
        ");
        $stmt->execute([
            ":hp" => $newHP,
            ":next" => $def_joueur
        ]);

        echo json_encode([
            "resultat" => "vaisseau_touche",
            "vaisseau" => $newHP
        ]);
        exit();
    }

    ///////////////////////////////////////////////////
    // Cas drone contre drone
    ///////////////////////////////////////////////////
    $result = combatResultat($atk_drone, $def_drone);

    if ($result === "avantagé") {

        $newHP = max(0, $game[$defField] - 1);

        $stmt = $conn->prepare("
            UPDATE game SET
                $defField = :hp,
                attaque_joueur = NULL,
                attaque_drone = NULL,
                attaque_cible = NULL,
                defense_drone = NULL,
                phase = 'attente',
                joueur = :next
            WHERE id = 1
        ");
        $stmt->execute([
            ":hp" => $newHP,
            ":next" => $def_joueur
        ]);

        echo json_encode([
            "resultat" => "avantagé",
            "cible_hp" => $newHP
        ]);
        exit();
    }

    // Egalite ou desavantage => pas de degats
    $stmt = $conn->prepare("
        UPDATE game SET
            attaque_joueur = NULL,
            attaque_drone = NULL,
            attaque_cible = NULL,
            defense_drone = NULL,
            phase = 'attente',
            joueur = :next
        WHERE id = 1
    ");
    $stmt->execute([
        ":next" => $def_joueur
    ]);

    echo json_encode([
        "resultat" => $result,
        "degats" => 0
    ]);
    exit();
}

///////////////////////////////////////////////////////
// JOKER REPARATION
///////////////////////////////////////////////////////
if ($action === "repair") {

    $joueur = intval($_POST["joueur"]);
    $drone = $_POST["drone"]; // pierre, feuille, ciseau

    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    $game = $stmt->fetch(PDO::FETCH_ASSOC);

    // Pas d'attaque en cours ni de bluff
    if ($game["phase"] !== "attente" || !empty($game["phase_bluff"])) {
        echo json_encode(["error" => "phase_invalide"]);
        exit();
    }

    if ($game["joueur"] != $joueur) {
        echo json_encode(["error" => "pas_ton_tour"]);
        exit();
    }

    $joker_col = "joker" . $joueur;
    if ($game[$joker_col] <= 0) {
        echo json_encode(["error" => "plus_de_joker"]);
        exit();
    }

    $field = $drone . $joueur;
    $pv_actuel = $game[$field];

    // +2 PV, max 3
    $nouveau_pv = $pv_actuel + 2;
    if ($nouveau_pv > 3) {
        $nouveau_pv = 3;
    }

    $stmt = $conn->prepare("
        UPDATE game SET
            $field = :pv,
            $joker_col = $joker_col - 1,
            joueur = IF(joueur = 1, 2, 1),
            phase = 'attente'
        WHERE id = 1
    ");
    $stmt->execute([
        ":pv" => $nouveau_pv
    ]);

    echo json_encode([
        "status" => "repare",
        "drone" => $drone,
        "pv" => $nouveau_pv
    ]);
    exit();
}

///////////////////////////////////////////////////////
// JOKER BLUFF - PHASE 1 (annonce)
///////////////////////////////////////////////////////
if ($action === "bluff_start") {

    $joueur = intval($_POST["joueur"]);
    $annonce = $_POST["annonce"]; // pierre/feuille/ciseau
    $reel = $_POST["reel"];       // pierre/feuille/ciseau

    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    $game = $stmt->fetch(PDO::FETCH_ASSOC);

    // On ne peut bluffer que si aucune attaque en cours et aucun bluff
    if ($game["phase"] !== "attente" || !empty($game["phase_bluff"])) {
        echo json_encode(["error" => "phase_invalide"]);
        exit();
    }

    if ($game["joueur"] != $joueur) {
        echo json_encode(["error" => "pas_ton_tour"]);
        exit();
    }

    $joker_col = "joker" . $joueur;
    if ($game[$joker_col] <= 0) {
        echo json_encode(["error" => "plus_de_joker"]);
        exit();
    }

    // Validation simple des valeurs
    $valid = ["pierre", "feuille", "ciseau"];
    if (!in_array($annonce, $valid) || !in_array($reel, $valid)) {
        echo json_encode(["error" => "valeur_invalide"]);
        exit();
    }

    $stmt = $conn->prepare("
        UPDATE game SET
            $joker_col = $joker_col - 1,
            bluff_joueur = :j,
            bluff_annonce = :a,
            bluff_reel = :r,
            bluff_choix = NULL,
            phase_bluff = 'reponse'
        WHERE id = 1
    ");
    $stmt->execute([
        ":j" => $joueur,
        ":a" => $annonce,
        ":r" => $reel
    ]);

    echo json_encode(["status" => "bluff_enregistré"]);
    exit();
}

///////////////////////////////////////////////////////
// JOKER BLUFF - PHASE 2 (reponse)
///////////////////////////////////////////////////////
if ($action === "bluff_answer") {

    $joueur = intval($_POST["joueur"]);
    $choix = $_POST["choix"]; // "croire" ou "ment"

    $stmt = $conn->prepare("SELECT * FROM game WHERE id = 1");
    $stmt->execute();
    $game = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($game["phase_bluff"] !== "reponse") {
        echo json_encode(["error" => "phase_invalide"]);
        exit();
    }

    $bluffeur = intval($game["bluff_joueur"]);
    if ($joueur == $bluffeur) {
        echo json_encode(["error" => "pas_ton_role"]);
        exit();
    }

    if ($choix !== "croire" && $choix !== "ment") {
        echo json_encode(["error" => "choix_invalide"]);
        exit();
    }

    $truth = ($game["bluff_reel"] === $game["bluff_annonce"]);

    $victime = null;
    $type_result = "";

    // Cas ou le defenseur se trompe => perd 2 PV
    if (($truth && $choix === "ment") || (!$truth && $choix === "croire")) {
        $victime = $joueur;
        $type_result = "victime_defenseur";
    }
    // Cas ou le defenseur detecte bien le bluff => bluffeur perd 2 PV
    elseif ((!$truth && $choix === "ment") || ($truth && $choix === "croire")) {
        if (!$truth && $choix === "ment") {
            $victime = $bluffeur;
            $type_result = "victime_bluffeur";
        } else {
            // truth et croire => aucun degat
            $victime = null;
            $type_result = "aucun_degats";
        }
    }

    $updateSql = "
        UPDATE game SET
            bluff_annonce = NULL,
            bluff_reel = NULL,
            bluff_choix = NULL,
            bluff_joueur = NULL,
            phase_bluff = NULL,
            joueur = :next
    ";

    $params = [":next" => $joueur];

    $pv_apres = null;

    if (!is_null($victime)) {
        $colV = "vaisseau" . $victime;
        $currentHP = $game[$colV];
        $newHP = $currentHP - 2;
        if ($newHP < 0) {
            $newHP = 0;
        }
        $updateSql .= ", $colV = :hp";
        $params[":hp"] = $newHP;
        $pv_apres = $newHP;
    }

    $updateSql .= " WHERE id = 1";

    $stmt = $conn->prepare($updateSql);
    $stmt->execute($params);

    echo json_encode([
        "resultat" => $type_result,
        "victime" => $victime,
        "pv" => $pv_apres
    ]);
    exit();
}

///////////////////////////////////////////////////////
// ACTION INCONNUE
///////////////////////////////////////////////////////
echo json_encode(["error" => "action_inconnue"]);
exit();
